/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.config;

import filenet.vw.api.VWException;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.utils.VWSessionInfo;

public class VWDesignerRegionNode
extends VWConfigRegionNode {
    private VWDesignerCoreData m_designerCoreData = null;
    private boolean m_bUseCurrentConfig = false;

    public VWDesignerRegionNode(String name, VWDesignerCoreData designerCoreData) {
        super(name);
        this.m_designerCoreData = designerCoreData;
    }

    public void logon(VWSessionInfo sessionInfo) throws Exception {
        try {
            int nSecondIndex;
            this.m_sessionInfo = sessionInfo;
            this.m_bInitialized = this.m_sessionInfo.getSession().isRegionInitialized();
            this.m_configuration = this.m_designerCoreData.getDataDictionary().getSystemConfiguration();
            this.m_router = this.m_sessionInfo.getSession().getConnectionPointName();
            this.m_regionID = this.m_sessionInfo.getSession().getIsolatedRegion();
            this.m_serviceName = this.m_sessionInfo.getSession().getServerName();
            int nFirstIndex = this.m_serviceName.indexOf(":");
            if (nFirstIndex != -1 && (nSecondIndex = this.m_serviceName.lastIndexOf(":")) != -1) {
                this.m_serviceName = this.m_serviceName.substring(nFirstIndex + 1, nSecondIndex);
            }
            if (this.m_bInitialized) {
                this.setupRegionConfig();
            }
            this.setLogonIcon(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void logoff() {
    }

    public void clear() {
    }

    public void initRegion() throws Exception {
    }

    public boolean isEditingSolution() {
        return this.m_designerCoreData.getSolutionHelper() != null;
    }

    public void refresh(boolean bRefetch) throws VWException {
        if (this.isEditingSolution() || this.m_bUseCurrentConfig) {
            this.refetchConfiguration();
            super.refresh(false);
        } else {
            super.refresh(bRefetch);
        }
    }

    protected void refetchConfiguration() throws VWException {
        if (this.isEditingSolution() || this.m_bUseCurrentConfig) {
            this.m_configuration = this.m_designerCoreData.getDataDictionary().getSystemConfiguration();
        } else {
            this.m_configuration = this.m_designerCoreData.getDataDictionary().refetchSystemConfiguration(true);
            this.fireStatusEvent(2);
        }
        this.m_admin = this.m_sessionInfo.getSession().fetchSystemAdministration();
        this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 757, null);
    }

    protected void setUseCurrentConfiguration(boolean bUseCurrentConfig) {
        this.m_bUseCurrentConfig = bUseCurrentConfig;
    }
}

